import 'package:admin_desktop/domain/repository/masters_repository.dart';
import 'package:admin_desktop/infrastructure/constants/constants.dart';
import 'package:flutter/material.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:admin_desktop/domain/models/models.dart';
import 'package:admin_desktop/infrastructure/services/utils.dart';
import 'disable_times_state.dart';

class MasterDisableTimesNotifier
    extends StateNotifier<MasterDisableTimesState> {
  final MastersRepository _mastersRepository;

  MasterDisableTimesNotifier(this._mastersRepository)
      : super(const MasterDisableTimesState());
  String? _endValue;
  String? _customRepeatValue;
  String? _customRepeatType;

  void setRepeats(String repeats) {
    state = state.copyWith(
      disableTime: state.disableTime?.copyWith(repeats: repeats),
    );
  }

  void setEndType(String endType) {
    state = state.copyWith(
      disableTime: state.disableTime?.copyWith(endType: endType),
    );
  }

  void setTimeTo(String? value) {
    state = state.copyWith(
      disableTime: state.disableTime?.copyWith(to: value),
    );
  }

  void setTimeFrom(String? value) {
    state = state.copyWith(
      disableTime: state.disableTime?.copyWith(from: value),
    );
  }

  void setDateTime(DateTime? value) {
    state = state.copyWith(
      disableTime: state.disableTime?.copyWith(date: value),
    );
  }

  void clearAll() {
    DisableTimes disableTime = DisableTimes(
      repeats: DropDownValues.repeatsList.first,
      endType: DropDownValues.endTypeList.first,
      customRepeatType: DropDownValues.customRepeatType.first,
    );
    state = state.copyWith(
      disableTime: disableTime,
      isLoading: false,
      isUpdate: false,
    );
  }

  String setEndDate(DateTime? value) => _endValue = TimeService.dateFormatDay(value);

  String setEndValue(String value) => _endValue = value;

  String setCustomRepeatValue(String value) => _customRepeatValue = value;

  String setCustomRepeatType(String value) => _customRepeatType = value;

  Future<void> fetchDisableTimeDetails(
    BuildContext context, {
    required DisableTimes? disableTime,
  }) async {
    state = state.copyWith(
      disableTime: disableTime,
      isLoading: true,
      isUpdate: false,
    );
    final res = await _mastersRepository.getDisableTimeDetails(disableTime?.id);
    res.when(success: (data) {
      state = state.copyWith(isLoading: false, disableTime: data.data);
    }, failure: (failure, status) {
      state = state.copyWith(isLoading: false);
      AppHelpers.errorSnackBar(context, text: failure);
    });
  }

  Future<void> updateDisableTimeDetails({
    required String title,
    required String desc,
    VoidCallback? updateSuccess,
  }) async {
    state = state.copyWith(isUpdate: true);
    final response = await _mastersRepository.updateDisableTimes(
      time: state.disableTime!.copyWith(
          translation: Translation(
            title: title,
            description: desc,
          ),
          customRepeatValue: (_customRepeatValue?.isNotEmpty ?? false)
              ? [_customRepeatValue!]
              : null,
          endValue: _endValue,
          customRepeatType: _customRepeatType),
      id: state.disableTime?.id,
    );
    response.when(
      success: (data) {
        state = state.copyWith(isUpdate: false);
        updateSuccess?.call();
      },
      failure: (failure, status) {
        state = state.copyWith(isUpdate: false);
        debugPrint('==> error update disable times days $failure');
      },
    );
  }

  Future<void> addDisableTimes({
    required String title,
    required String desc,
    required int masterId,
    VoidCallback? createdSuccess,
  }) async {
    state = state.copyWith(isUpdate: true);
    final response = await _mastersRepository.addDisableTimes(
      time: state.disableTime?.copyWith(
              translation: Translation(
                title: title,
                description: desc,
              ),
              masterId: masterId,
              customRepeatValue: (_customRepeatValue?.isNotEmpty ?? false)
                  ? [_customRepeatValue!]
                  : null,
              endValue: _endValue,
              customRepeatType: _customRepeatType) ??
          DisableTimes(),
      id: state.disableTime?.id,
    );
    response.when(
      success: (data) {
        state = state.copyWith(isUpdate: false);
        createdSuccess?.call();
      },
      failure: (failure, status) {
        state = state.copyWith(isUpdate: false);
        debugPrint('==> error update disable times days $failure');
      },
    );
  }

  Future<void> deleteDisableTimes({
    int? id,
    VoidCallback? createdSuccess,
  }) async {
    state = state.copyWith(isUpdate: true);
    final response = await _mastersRepository.deleteDisableTimes(
      id: id,
    );
    response.when(
      success: (data) {
        state = state.copyWith(isUpdate: false);
        createdSuccess?.call();
      },
      failure: (failure, status) {
        state = state.copyWith(isUpdate: false);
        debugPrint('==> error update disable times days $failure');
      },
    );
  }
}
